<?php
/*--------------------------------------------------------------------
 ReadService.php 2020-2-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitImages\Database\Service;

use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\Properties\SellingUnitImages\Database\Repository\RepositoryInterface;
use Gambio\Shop\SellingUnit\Images\Entities\Interfaces\SellingUnitImageInterface;
use Gambio\Shop\SellingUnit\Images\Entities\Interfaces\SellingUnitImageCollectionInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Properties\SellingUnitImages\Database\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getMainImageListImage(
        ProductId $identification,
        ModifierIdentifierCollectionInterface $identifierCollection,
        LanguageId $languageId
    ): SellingUnitImageInterface {
        
        return $this->repository->getMainImageListImage($identification, $identifierCollection, $languageId);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getImageListImages(
        ProductId $identification,
        ModifierIdentifierCollectionInterface $identifierCollection,
        LanguageId $languageId
    ): SellingUnitImageCollectionInterface {
        
        return $this->repository->getImageListImages($identification, $identifierCollection, $languageId);
    }
}